#if !defined(AFX_ENVELOPECTL_H__396D2EC4_53AA_11D1_A1D9_4676EE000000__INCLUDED_)
#define AFX_ENVELOPECTL_H__396D2EC4_53AA_11D1_A1D9_4676EE000000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

// EnvelopeCtl.h : Declaration of the CEnvelopeCtrl ActiveX Control class.

/////////////////////////////////////////////////////////////////////////////
// CEnvelopeCtrl : See EnvelopeCtl.cpp for implementation.

class CEnvelopeCtrl : public COleControl
{
	DECLARE_DYNCREATE(CEnvelopeCtrl)

// Constructor
public:
	CEnvelopeCtrl();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CEnvelopeCtrl)
	public:
	virtual void OnDraw(CDC* pdc, const CRect& rcBounds, const CRect& rcInvalid);
	virtual void DoPropExchange(CPropExchange* pPX);
	virtual void OnResetState();
	virtual DWORD GetControlFlags();
	//}}AFX_VIRTUAL

private:
	void DrawPlayPos(CDC *pDC, int const newpos);
	long LastPlayPos;
	void Reset();
	CRect Bounds;
	void EnvChanged();
	int SustainPoint;
	CPoint PopupPoint;
	int GetHandleLeftTo(int const x);
	void ClampHandle(int const i);
	int iDragHandle;
	int GetHandleAt(CPoint const &p);
	void DrawHandle(CDC *pdc, CPoint const &p);
	CPoint PS2SS(CPoint const &p);
	CPoint SS2PS(CPoint const &p);
	PointVector Handles;

// Implementation
protected:
	afx_msg void OnContextMenu(CWnd*, CPoint point);
	~CEnvelopeCtrl();

	DECLARE_OLECREATE_EX(CEnvelopeCtrl)    // Class factory and guid
	DECLARE_OLETYPELIB(CEnvelopeCtrl)      // GetTypeInfo
	DECLARE_PROPPAGEIDS(CEnvelopeCtrl)     // Property page IDs
	DECLARE_OLECTLTYPE(CEnvelopeCtrl)		// Type name and misc status

// Message maps
	//{{AFX_MSG(CEnvelopeCtrl)
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnAddPoint();
	afx_msg void OnDeletePoint();
	afx_msg void OnUpdateDeletePoint(CCmdUI* pCmdUI);
	afx_msg void OnSustain();
	afx_msg void OnUpdateSustain(CCmdUI* pCmdUI);
	afx_msg void OnReset();
	afx_msg void OnInvert();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

// Dispatch maps
	//{{AFX_DISPATCH(CEnvelopeCtrl)
	afx_msg void SetEnvelope(long numPoints, long SustainPoint, long FAR* Points);
	afx_msg void SetPlayPosition(long x);
	//}}AFX_DISPATCH
	DECLARE_DISPATCH_MAP()

// Event maps
	//{{AFX_EVENT(CEnvelopeCtrl)
	void FireEnvelopeChanged(long numPoints, long SustainPoint, long FAR* Points)
		{FireEvent(eventidEnvelopeChanged,EVENT_PARAM(VTS_I4  VTS_I4  VTS_PI4), numPoints, SustainPoint, Points);}
	//}}AFX_EVENT
	DECLARE_EVENT_MAP()

// Dispatch and event IDs
public:
	enum {
	//{{AFX_DISP_ID(CEnvelopeCtrl)
	dispidSetEnvelope = 1L,
	dispidSetPlayPosition = 2L,
	eventidEnvelopeChanged = 1L,
	//}}AFX_DISP_ID
	};
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_ENVELOPECTL_H__396D2EC4_53AA_11D1_A1D9_4676EE000000__INCLUDED)
